local SongMeterColor = {
	["plus"] = color("#B9C130"),
	["lazarus"] = color("#859AFF"),
	["nightlife"] = color("#FF9658"),
	["timerift"] = color("#1E9976"),
	["bluerift"] = color("#5FA1CA"),
	["violet"] = color("#D6AE43")
}

local gear = LoadModule("Config.Load.lua")("LazarusGear","Save/LazarusPrefs.ini");

local function GetPlScore(pl, scoretype)
	local primary_score = STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetScore()
	local secondary_score = FormatPercentScore(STATSMAN:GetCurStageStats():GetPlayerStageStats(pl):GetPercentDancePoints())

	if PREFSMAN:GetPreference("PercentageScoring") then
		primary_score, secondary_score = secondary_score, primary_score
	end

	if scoretype == "primary" then
		return primary_score
	else
		return secondary_score
	end
end

-- Progress bar function
local function UpdateTime(self)
	local c = self:GetChildren();
	for pn in ivalues(PlayerNumber) do
		local vStats = STATSMAN:GetCurStageStats():GetPlayerStageStats( pn );
		local vTime;
		local obj = self:GetChild( string.format("RemainingTime" .. PlayerNumberToString(pn) ) );
		if vStats and obj then
			vTime = vStats:GetLifeRemainingSeconds()
			obj:settext( SecondsToMMSSMsMs( vTime ) );
		end;
	end;
end
local function songMeterScale(val) return scale(val,0,1,-380/2,380/2) end	

local t = Def.ActorFrame {};

t[#t+1] = Def.Quad {
	InitCommand=function(self)
		self:horizalign(center):vertalign(top):x(SCREEN_CENTER_X):y(SCREEN_TOP)
		self:zoomto(SCREEN_WIDTH,100):diffuse(color("#000000"))
	end;
	OnCommand=function(self)
		self:fadebottom(1.0):diffusealpha(0.75)
	end;
	OffCommand=function(self)
		self:sleep(1.4):decelerate(3):addy(-260)
	end;
};

t[#t+1] = Def.Sprite {
	Texture="_frame " .. gear;
	InitCommand=function(self)
		self:x(SCREEN_CENTER_X):y(SCREEN_TOP+30)
	end;
	OnCommand=function(self)
		self:addy(-260):decelerate(0.6):addy(260)
	end;
	OffCommand=function(self)
		self:sleep(1.4):decelerate(3):addy(-260)
	end;
};

t[#t+1] = Def.Sprite {
	Texture="_glow " .. gear;
	InitCommand=function(self)
		self:x(SCREEN_CENTER_X):y(SCREEN_TOP+30):blend('add')
	end;
	OnCommand=function(self)
		self:addy(-260):decelerate(0.6):addy(260)
		self:diffuseramp():effectclock("beatnooffset"):effectcolor1(1,1,1,1):effectcolor2(1,1,1,0.3)
	end;
	OffCommand=function(self)
		self:sleep(1.4):decelerate(3):addy(-260)
	end;
};

t[#t+1] = Def.SongMeterDisplay {
	InitCommand=function(self)
		self:x(SCREEN_CENTER_X):y(SCREEN_TOP+29)
	end;
	OnCommand=function(self)
		self:addy(-260):decelerate(0.6):addy(260)
		self:diffuseramp():effectclock("beatnooffset"):effectcolor1(1,1,1,0.7):effectcolor2(1,1,1,0.6)
	end;
	OffCommand=function(self)
		self:sleep(1.4):decelerate(3):addy(-260)
	end;
	StreamWidth=200;
	Stream=LoadActor( THEME:GetPathG( 'SongMeterDisplay', 'stream') )..{
		InitCommand=function(self)
			self:vertalign(middle)
		end;
		OnCommand=function(self)
			self:diffuse(SongMeterColor[gear])
		end;
	};
	Tip=LoadActor( THEME:GetPathG( 'SongMeterDisplay', 'tip')) .. { 
		InitCommand=function(self)
			self:vertalign(middle):visible(false)
		end;
	};
};

--- Song info
t[#t+1] = LoadFont("Common Normal") .. {
	InitCommand=function(self)
		self:x(SCREEN_CENTER_X):y(SCREEN_TOP+18):zoom(0.5):maxwidth(420/0.5):horizalign(center)
	end;
	OnCommand=function(self)
		if gear == "plus" then 
			self:diffuse(color("#B9C130"))
		elseif gear == "timerift" then 
			self:diffuse(color("#75DCDB")):diffusetopedge(color("#92F5E7")):addy(-3)	
		elseif gear == "bluerift" then 
			self:diffuse(color("#5494E2")):diffusetopedge(color("#5FA1CA")):addy(-3)
		elseif gear == "nightlife" then
			self:diffuse(color("#FF9658")):diffusebottomedge(color("#FC8037"))
		elseif gear == "violet" then
			self:diffuse(color("#D6AE43")):diffusebottomedge(color("#FFD566"))
		else
			self:diffuse(color("#FFFFFF")):diffusetopedge(color("#EBF2FF"))
		end;
		self:addy(-260):decelerate(0.6):addy(260)
	end;
	OffCommand=function(self)
		self:sleep(1.4):decelerate(3):addy(-260)
	end;
	CurrentSongChangedMessageCommand=function(self)
		   local song = GAMESTATE:GetCurrentSong();
		   if song then
				self:settext(song:GetDisplayFullTitle());
				self:playcommand("Refresh");
			else
				self:settext("");
				self:playcommand("Refresh");
		   end
	  end;
};

for ip, pn in ipairs(GAMESTATE:GetEnabledPlayers()) do
		local score_x_position = string.find(pn, "P1") and SCREEN_CENTER_X-300 or SCREEN_CENTER_X+300;
		local level_x_position = string.find(pn, "P1") and SCREEN_CENTER_X-296 or SCREEN_CENTER_X+296;
		local score_align = string.find(pn, "P1") and left or right;
		local vStats = STATSMAN:GetCurStageStats():GetPlayerStageStats( pn );
		
		t[#t+1] = Def.ActorFrame {
		OnCommand=function(self)
			self:addy(-260):decelerate(0.6):addy(260)
		end;
		OffCommand=function(self)
			self:sleep(1.4):decelerate(3):addy(-260)
		end;
			Def.BitmapText {
				Font="Common Normal",
				InitCommand=function(self)
					self:xy(score_x_position,SCREEN_TOP+35):horizalign(score_align):maxwidth(150):zoom(0.75)
					if gear == "plus" then 
						self:diffuse(color("#FFFFFF")) 					
					elseif gear == "timerift" then 
						self:diffuse(color("#92F5E7")) 					
					elseif gear == "bluerift" then 
						self:diffuse(color("#5494E2")):diffusetopedge(color("#5FA1CA"))
					elseif gear == "nightlife" then 
						self:diffuse(color("#FF9658")):diffusebottomedge(color("#FC8037"))
					elseif gear == "violet" then 
						self:diffuse(color("#FFFEFF")):diffusebottomedge(color("#A89FA7"))
					else 
						self:diffuse(color("#000000")) 
					end;
					if PREFSMAN:GetPreference("PercentageScoring") then
						self:settext("0.00%")
					else
						self:settext("0")
					end
				end,
				OnCommand=function(self)
					if GAMESTATE:GetPlayMode() == "PlayMode_Endless" then
						self:queuecommand("UpdateTimer")
					end
				end;
				JudgmentMessageCommand=function(self)
					if GAMESTATE:GetPlayMode() == "PlayMode_Endless" then
						self:queuecommand("UpdateTimer")
					else
						self:queuecommand("RedrawScore")
					end
				end,
				UpdateTimerCommand=function(self)
					self:finishtweening():settext( SecondsToMMSSMsMs( vStats:GetAliveSeconds() ) )
					:sleep(1/60):queuecommand("UpdateTimer")
				end;
				RedrawScoreCommand=function(self)
					self:settext(GetPlScore(pn, "primary"))
				end;
			};
			Def.Sprite {
			Texture="_level.png";
			InitCommand=function(self)
				self:xy(score_x_position,SCREEN_TOP+19):zoom(1):horizalign(score_align)
			end;
			OnCommand=function(self)
					self:playcommand("Set")
				end;
			["CurrentSteps"..ToEnumShortString(pn).."ChangedMessageCommand"]=function(self) self:playcommand("Set") end;
			SetCommand=function(self)
					local steps_data = GAMESTATE:GetCurrentSteps(pn)
						if GAMESTATE:GetCurrentSong() then
							if steps_data ~= nil then
							local cd = GetCustomDifficulty(steps_data:GetStepsType(), steps_data:GetDifficulty());
							if gear == "lazarus" then
								self:diffuse(ColorMidTone(CustomDifficultyToColor(cd)));
							else
								self:diffuse(ColorDarkTone(CustomDifficultyToColor(cd)));
							end;
						end
					end
			end;
			};			
			LoadFont("Common normal") .. { 
				InitCommand=function(self)
					self:xy(level_x_position,SCREEN_TOP+19):zoom(0.4):horizalign(score_align):diffuse(color("#000000")):maxwidth(35/0.4) 
				end;
				OnCommand=function(self)
					self:playcommand("Set")
				end;
				["CurrentSteps"..ToEnumShortString(pn).."ChangedMessageCommand"]=function(self) self:playcommand("Set") end;
				SetCommand=function(self)
						local steps_data = GAMESTATE:GetCurrentSteps(pn)
						if GAMESTATE:GetCurrentSong() then
							if steps_data ~= nil then
							local st = steps_data:GetStepsType();
							local diff = steps_data:GetDifficulty();
							local cd = GetCustomDifficulty(st, diff);
							self:settext("Lv. " .. steps_data:GetMeter())
								if gear == "timerift" then
									self:diffuse(BoostColor(ColorLightTone(CustomDifficultyToColor(cd)),1.3));
								else
									self:diffuse(color("#FFFFFF"));
								end;
						end
					end
				end;
			};
		};
	end;
	t[#t+1] = LoadActor("bpmDisplay.lua");
	
return t;